# Arcade Platform - Production Build

This is a production-ready build of the Arcade Platform.

## Quick Start

1. **Install Dependencies**
   ```bash
   npm install --production
   ```
   
   **Note:** This build does NOT include `node_modules` to keep the package size small and ensure clean dependencies. Dependencies will be installed fresh on the production server.

2. **Configure Environment**
   ```bash
   cp .env.example .env
   # Edit .env with your configuration
   ```

3. **Setup Database**
   ```bash
   # Create your database and run migrations
   npm run migrate:up
   ```

4. **Start the Application**
   ```bash
   npm start
   ```

## Configuration

### Environment Variables

Copy `.env.example` to `.env` and configure:

- **Database**: Set your MySQL connection details
- **Security**: Configure session secrets and CORS origins
- **Server**: Set port and environment settings
- **Email**: Configure SMTP for email functionality (optional)
- **OAuth**: Configure social login (optional)

### Database Setup

1. Create a MySQL database
2. Update `.env` with your database credentials
3. Run migrations: `npm run migrate:up`

### Production Deployment

For production deployment, consider:

- Using a process manager like PM2
- Setting up a reverse proxy (nginx)
- Configuring SSL certificates
- Setting up proper logging and monitoring

## File Structure

```
dist/
├── app.js                 # Main application file
├── package.json           # Production dependencies
├── .env.example          # Environment configuration template
├── src/                   # Application source code
├── views/                 # EJS templates
├── public/                # Static assets
├── scripts/               # Utility scripts
├── migrations/            # Database migrations
└── uploads/               # User uploads directory
```

## Support

For support and documentation, visit the project repository.

## License

This software is licensed under the terms specified in the original package.
