#!/bin/bash

# Arcade Platform Deployment Script
# This script helps deploy the production build

set -e

echo "🚀 Starting Arcade Platform Deployment..."

# Check if Node.js is installed
if ! command -v node &> /dev/null; then
    echo "❌ Node.js is not installed. Please install Node.js first."
    exit 1
fi

# Check if npm is installed
if ! command -v npm &> /dev/null; then
    echo "❌ npm is not installed. Please install npm first."
    exit 1
fi

# Check if .env file exists
if [ ! -f ".env" ]; then
    echo "⚠️  .env file not found. Creating from template..."
    if [ -f ".env.example" ]; then
        cp .env.example .env
        echo "✅ .env file created from template. Please configure it before continuing."
        echo "📝 Edit .env file with your database and server configuration."
        exit 1
    else
        echo "❌ .env.example not found. Cannot create .env file."
        exit 1
    fi
fi

# Install production dependencies
echo "📦 Installing production dependencies..."
echo "   Note: node_modules are not included in this build for security and size reasons"
echo "   Dependencies will be installed fresh from package.json"
npm install --production

# Run database migrations
echo "🗄️  Running database migrations..."
npm run migrate:up

echo "✅ Deployment completed successfully!"
echo ""
echo "🎮 To start the application:"
echo "   npm start"
echo ""
echo "🌐 The application will be available at the port specified in your .env file."
echo "📊 Access the admin dashboard at: http://your-domain/dashboard"
