let socket,loadingProgress=0,loadingMessages=[__("chatroom.loading.starting_world"),__("chatroom.loading.loading_characters"),__("chatroom.loading.setting_up_profile"),__("chatroom.loading.preparing_3d"),__("chatroom.loading.setting_up_camera"),__("chatroom.loading.creating_3d"),__("chatroom.loading.setting_up_lighting"),__("chatroom.loading.connecting_to_server"),__("chatroom.loading.finalizing_setup"),__("chatroom.loading.welcome_to_world")],currentMessageIndex=0;function updateLoadingProgress(e,t=null){const o=document.getElementById("loadingProgressFill"),a=document.getElementById("loadingPercentage"),n=document.getElementById("loadingMessage");o&&(o.style.width=`${e}%`),a&&(a.textContent=`${Math.round(e)}%`),t&&n&&(n.style.animation="none",n.offsetHeight,n.style.animation="fadeInOut 1s ease-in-out",n.textContent=t),loadingProgress=e}function showNextLoadingMessage(){currentMessageIndex<loadingMessages.length&&(updateLoadingProgress(loadingProgress,loadingMessages[currentMessageIndex]),currentMessageIndex++)}function hideLoadingScreen(){const e=document.getElementById("loadingScreen");e&&(e.classList.add("fade-out"),setTimeout(()=>{e.style.display="none"},500))}document.addEventListener("DOMContentLoaded",function(){updateLoadingProgress(5,__("chatroom.loading.starting_world"))});let types=[],userProfile=null,chatroomData=null,name="",charType="Fighter",lastCoordinateSave=0;const COORDINATE_SAVE_INTERVAL=5e3;function createMedievalJapaneseEnvironment(e){createChatroomEnvironment(e)}const collisionObjects=[],mapRadius=45;function getRankColor(e){return e>=20?"#8B5CF6":e>=15?"#F59E0B":e>=10?"#EF4444":e>=5?"#10B981":"#3B82F6"}function addCollisionCircle(e,t,o){collisionObjects.push({type:"circle",x:e,z:t,radius:o})}function addCollisionRect(e,t,o,a){collisionObjects.push({type:"rect",x:e,z:t,width:o,height:a})}function checkCollision(e,t,o=1){if(Math.sqrt(e*e+t*t)+o>45)return!0;for(const a of collisionObjects)if("circle"===a.type){const n=e-a.x,r=t-a.z;if(Math.sqrt(n*n+r*r)<a.radius+o)return!0}else if("rect"===a.type){const n=a.width/2,r=a.height/2;if(e+o>a.x-n&&e-o<a.x+n&&t+o>a.z-r&&t-o<a.z+r)return!0}return!1}function createSkyEnvironment(e){const t=new THREE.SphereGeometry(200,32,32),o=new THREE.MeshBasicMaterial({color:8900331,side:THREE.BackSide,transparent:!0,opacity:.8}),a=new THREE.Mesh(t,o);e.add(a);const n=new THREE.SphereGeometry(5,16,16),r=new THREE.MeshBasicMaterial({color:16766720,emissive:16766720,emissiveIntensity:.5}),i=new THREE.Mesh(n,r);i.position.set(80,60,-40),e.add(i),createClouds(e)}function createClouds(e){[{x:-60,y:45,z:-80,scale:1.2},{x:-30,y:50,z:-70,scale:.8},{x:0,y:55,z:-75,scale:1.5},{x:40,y:48,z:-65,scale:1},{x:70,y:52,z:-85,scale:1.3},{x:-40,y:42,z:60,scale:.9},{x:20,y:58,z:70,scale:1.1},{x:60,y:46,z:65,scale:.7},{x:-90,y:40,z:-20,scale:1.4},{x:90,y:44,z:30,scale:1},{x:-20,y:62,z:40,scale:.6},{x:10,y:38,z:-90,scale:1.2}].forEach(t=>{createCloud(e,t.x,t.y,t.z,t.scale)})}function createCloud(e,t,o,a,n=1){const r=new THREE.Group;[{x:0,y:0,z:0,scale:1},{x:-2,y:.5,z:1,scale:.8},{x:2,y:-.2,z:-1,scale:.9},{x:1,y:.8,z:2,scale:.7},{x:-1.5,y:-.5,z:-2,scale:.6},{x:.5,y:1.2,z:0,scale:.5}].forEach(e=>{const t=new THREE.SphereGeometry(3*e.scale,12,12),o=new THREE.MeshLambertMaterial({color:16777215,transparent:!0,opacity:.8}),a=new THREE.Mesh(t,o);a.position.set(e.x*n,e.y*n,e.z*n),r.add(a)}),r.position.set(t,o,a),r.scale.multiplyScalar(n),e.add(r)}function createChatroomEnvironment(e){collisionObjects.length=0,createSkyEnvironment(e);const t=new THREE.CircleGeometry(50,32),o=new THREE.MeshLambertMaterial({color:8097131,transparent:!0,opacity:.9}),a=new THREE.Mesh(t,o);a.rotation.x=-Math.PI/2,e.add(a);const n=new THREE.CircleGeometry(15,16),r=new THREE.MeshLambertMaterial({color:12887172}),i=new THREE.Mesh(n,r);i.rotation.x=-Math.PI/2,i.position.y=.01,e.add(i),createChatroomPaths(e),createChatroomBuildings(e),createChatroomDecor(e)}function createChatroomPaths(e){const t=new THREE.MeshLambertMaterial({color:9143936});for(let o=0;o<4;o++){const a=o*Math.PI/2,n=new THREE.PlaneGeometry(3,25),r=new THREE.Mesh(n,t);r.rotation.x=-Math.PI/2,r.rotation.z=a,r.position.set(20*Math.cos(a),.005,20*Math.sin(a)),e.add(r)}}function createChatroomBuildings(e){[{x:-25,z:-25},{x:25,z:-25},{x:-25,z:25},{x:25,z:25}].forEach(t=>{createPavilion(e,t.x,t.z)}),createFountain(e)}function createPavilion(e,t,o){const a=new THREE.CylinderGeometry(6,6,.5),n=new THREE.MeshLambertMaterial({color:13808780}),r=new THREE.Mesh(a,n);r.position.set(t,.25,o),e.add(r);const i=new THREE.CylinderGeometry(.3,.3,6),s=new THREE.MeshLambertMaterial({color:16119260});for(let a=0;a<6;a++){const n=a*Math.PI*2/6,r=new THREE.Mesh(i,s);r.position.set(t+4*Math.cos(n),3.5,o+4*Math.sin(n)),e.add(r),addCollisionCircle(t+4*Math.cos(n),o+4*Math.sin(n),.5)}const l=new THREE.ConeGeometry(7,3,8),c=new THREE.MeshLambertMaterial({color:6636321}),d=new THREE.Mesh(l,c);d.position.set(t,8,o),e.add(d),addCollisionCircle(t,o,2)}function createFountain(e){const t=new THREE.CylinderGeometry(4,4,1),o=new THREE.MeshLambertMaterial({color:7372944}),a=new THREE.Mesh(t,o);a.position.set(0,.5,0),e.add(a);const n=new THREE.CylinderGeometry(3.5,3.5,.2),r=new THREE.MeshLambertMaterial({color:4620980,transparent:!0,opacity:.7}),i=new THREE.Mesh(n,r);i.position.set(0,1.1,0),e.add(i);const s=new THREE.CylinderGeometry(.5,.5,2),l=new THREE.Mesh(s,o);l.position.set(0,2,0),e.add(l),addCollisionCircle(0,0,4.5)}function createChatroomDecor(e){[{x:-35,z:0},{x:35,z:0},{x:0,z:-35},{x:0,z:35},{x:-30,z:-30},{x:30,z:-30},{x:-30,z:30},{x:30,z:30}].forEach(t=>{createTree(e,t.x,t.z)});[{x:-10,z:-10},{x:10,z:-10},{x:-10,z:10},{x:10,z:10}].forEach(t=>{createLampPost(e,t.x,t.z)});[{x:-20,z:-15,scale:1},{x:22,z:-18,scale:.8},{x:-15,z:20,scale:1.2},{x:18,z:22,scale:.9},{x:-8,z:-25,scale:.7},{x:12,z:-28,scale:1.1},{x:-28,z:8,scale:.9},{x:25,z:12,scale:1},{x:-32,z:-12,scale:.8},{x:28,z:-8,scale:1.3},{x:-12,z:32,scale:1},{x:15,z:35,scale:.9},{x:6,z:-20,scale:.6},{x:-18,z:25,scale:1.1}].forEach(t=>{createBush(e,t.x,t.z,t.scale)});[{x:-12,z:-8,type:"red"},{x:8,z:-12,type:"yellow"},{x:-6,z:14,type:"purple"},{x:14,z:8,type:"pink"},{x:-16,z:6,type:"blue"},{x:6,z:-16,type:"orange"},{x:16,z:-6,type:"red"},{x:-8,z:18,type:"yellow"},{x:20,z:16,type:"purple"},{x:-22,z:-20,type:"pink"},{x:24,z:-22,type:"blue"},{x:-26,z:18,type:"orange"}].forEach(t=>{createFlowerPatch(e,t.x,t.z,t.type)})}function createTree(e,t,o){const a=new THREE.CylinderGeometry(.8,1,8),n=new THREE.MeshLambertMaterial({color:9127187}),r=new THREE.Mesh(a,n);r.position.set(t,4,o),e.add(r);const i=new THREE.SphereGeometry(5,12,8),s=new THREE.MeshLambertMaterial({color:2263842}),l=new THREE.Mesh(i,s);l.position.set(t,10,o),e.add(l),addCollisionCircle(t,o,1.5)}function createLampPost(e,t,o){const a=new THREE.CylinderGeometry(.1,.1,4),n=new THREE.MeshLambertMaterial({color:3092271}),r=new THREE.Mesh(a,n);r.position.set(t,2,o),e.add(r);const i=new THREE.SphereGeometry(.5,8,6),s=new THREE.MeshLambertMaterial({color:16775885,emissive:2232576,emissiveIntensity:.3}),l=new THREE.Mesh(i,s);l.position.set(t,4.5,o),e.add(l);const c=new THREE.PointLight(16775885,.5,20);c.position.set(t,4.5,o),e.add(c),addCollisionCircle(t,o,.3)}function createBush(e,t,o,a=1){const n=new THREE.Group;[{x:0,y:0,z:0,scale:1},{x:-.8,y:.2,z:.6,scale:.7},{x:.9,y:-.1,z:-.4,scale:.8},{x:.3,y:.4,z:.8,scale:.6},{x:-.6,y:-.2,z:-.9,scale:.5},{x:.7,y:.3,z:.2,scale:.7}].forEach(e=>{const t=new THREE.SphereGeometry(1.2*e.scale,8,6),o=new THREE.MeshLambertMaterial({color:2263842,transparent:!0,opacity:.9}),r=new THREE.Mesh(t,o);r.position.set(e.x*a,.8+e.y*a,e.z*a),n.add(r)}),n.position.set(t,0,o),n.scale.multiplyScalar(a),e.add(n),addCollisionCircle(t,o,1.2*a)}function createFlowerPatch(e,t,o,a="red"){const n={red:16739179,yellow:16767293,purple:10181046,pink:16738740,blue:3447003,orange:16747586},r=n[a]||n.red;for(let a=0;a<8;a++){const a=3*(Math.random()-.5),n=3*(Math.random()-.5),i=new THREE.CylinderGeometry(.05,.05,.4),s=new THREE.MeshLambertMaterial({color:2263842}),l=new THREE.Mesh(i,s);l.position.set(t+a,.2,o+n),e.add(l);const c=new THREE.SphereGeometry(.15,6,4),d=new THREE.MeshLambertMaterial({color:r,emissive:r,emissiveIntensity:.1}),p=new THREE.Mesh(c,d);p.position.set(t+a,.45,o+n),e.add(p);for(let r=0;r<2;r++){const r=new THREE.SphereGeometry(.08,4,3),i=new THREE.MeshLambertMaterial({color:3329330}),s=new THREE.Mesh(r,i);s.position.set(t+a+.3*(Math.random()-.5),.15+.1*Math.random(),o+n+.3*(Math.random()-.5)),s.scale.set(1,.3,1),e.add(s)}}}const characterConfigs={};function loadAvailableCharacterTypes(){return new Promise(e=>{$.ajax({url:"/chatroom/available-characters",method:"GET",dataType:"json"}).done(function(t){if(t&&t.characters&&Array.isArray(t.characters)&&t.characters.length>0)return types=t.characters,void e(types);const o=["Fighter","Ninja","Samurai"],a=[];let n=0;o.forEach(t=>{$.ajax({url:`/chatroom/assets/characters/${t}/character.json`,method:"GET",dataType:"json"}).done(function(){a.push(t)}).fail(function(e,t,o){400===e.status&&(window.chatroomLicenseError=!0)}).always(function(){n++,n===o.length&&(0===a.length&&window.chatroomLicenseError&&showErrorModal(__("errors.system_error")||"System Error",__("api.chatroom.character_types_error")||"Unable to load chatroom characters. Please contact support."),types=a.length>0?a:o.length>0?o:["Fighter"],e(types))})})}).fail(function(t,o,a){types=["Fighter"],e(types)})})}function loadCharacterConfig(e){return new Promise(t=>{characterConfigs[e]?t(characterConfigs[e]):$.ajax({url:`/chatroom/assets/characters/${e}/character.json`,method:"GET",dataType:"json"}).done(function(o){characterConfigs[e]=o,t(o)}).fail(function(o,a,n){400===o.status&&showErrorModal(__("errors.system_error")||"System Error",__("api.chatroom.character_update_failed")||"Unable to load character data. Please contact support if this continues."),t(getFallbackCharacterConfig(e))})})}function getFallbackCharacterConfig(e){const t={info:{name:e,displayName:e,description:`A ${e.toLowerCase()} character.`},display:{scale:{x:2,y:2,z:1},spriteHeight:2,pixelPerfect:!0,alphaTest:.1},animations:{frameRate:80,defaultAnimation:"Idle",states:{Idle:{type:"sheet",file:"Idle.png",frames:6,duration:480,loop:!0,priority:0},Idle_Left:{type:"sheet",file:"Idle_Left.png",frames:6,duration:480,loop:!0,priority:0},Walk:{type:"sheet",file:"Walk.png",frames:8,duration:640,loop:!0,priority:1},Walk_Left:{type:"sheet",file:"Walk_Left.png",frames:8,duration:640,loop:!0,priority:1},Run:{type:"sheet",file:"Run.png",frames:8,duration:640,loop:!0,priority:2},Run_Left:{type:"sheet",file:"Run_Left.png",frames:8,duration:640,loop:!0,priority:2},Attack_1:{type:"sheet",file:"Attack_1.png",frames:3,duration:600,loop:!1,priority:10,returnTo:"Idle"},Attack_1_Left:{type:"sheet",file:"Attack_1_Left.png",frames:3,duration:600,loop:!1,priority:10,returnTo:"Idle_Left"},Attack_2:{type:"sheet",file:"Attack_2.png",frames:4,duration:700,loop:!1,priority:10,returnTo:"Idle"},Attack_2_Left:{type:"sheet",file:"Attack_2_Left.png",frames:4,duration:700,loop:!1,priority:10,returnTo:"Idle_Left"},Attack_3:{type:"sheet",file:"Attack_3.png",frames:4,duration:600,loop:!1,priority:10,returnTo:"Idle"},Attack_3_Left:{type:"sheet",file:"Attack_3_Left.png",frames:4,duration:600,loop:!1,priority:10,returnTo:"Idle_Left"},Shield:{type:"sheet",file:"Shield.png",frames:2,duration:500,loop:!1,priority:8,returnTo:"Idle"},Shield_Left:{type:"sheet",file:"Shield_Left.png",frames:2,duration:500,loop:!1,priority:8,returnTo:"Idle_Left"},Jump:{type:"sheet",file:"Jump.png",frames:10,duration:900,loop:!1,priority:5,returnTo:"Idle"},Jump_Left:{type:"sheet",file:"Jump_Left.png",frames:10,duration:900,loop:!1,priority:5,returnTo:"Idle_Left"},Hurt:{type:"sheet",file:"Hurt.png",frames:3,duration:400,loop:!1,priority:15,returnTo:"Idle"},Hurt_Left:{type:"sheet",file:"Hurt_Left.png",frames:3,duration:400,loop:!1,priority:15,returnTo:"Idle_Left"},Dead:{type:"sheet",file:"Dead.png",frames:3,duration:1e3,loop:!1,priority:20,returnTo:null},Dead_Left:{type:"sheet",file:"Dead_Left.png",frames:3,duration:1e3,loop:!1,priority:20,returnTo:null}}}};return characterConfigs[e]=t,t}async function fetchUserProfile(){try{const e=await $.get("/requests/user-profile");return 200===e.status?e.data:null}catch(e){return null}}async function fetchChatroomData(){try{const e=await $.get("/chatroom/data");return 200===e.status?e.data:null}catch(e){return null}}async function saveCharacterSelection(e){try{return 200===(await $.post("/chatroom/update-character",{character:e})).status}catch(e){return!1}}async function saveCoordinates(e,t){const o=Date.now();if(!(o-lastCoordinateSave<5e3)){lastCoordinateSave=o;try{await $.post("/chatroom/save-coordinates",{x:e,z:t})}catch(e){}}}function setupPlayerForm(){const e=$("#playerSetupModal"),t=$("#playerSetupForm"),o=$("#charType"),a=$("#userProfileInfo"),n=$("#modalTitle"),r=$("#modalDescription"),i=$("#submitButton");return new Promise(async s=>(await loadAvailableCharacterTypes(),o.html(types.map(e=>`<option value="${e}">${e}</option>`).join("")),userProfile=await fetchUserProfile(),chatroomData=await fetchChatroomData(),userProfile?(name=userProfile.username,chatroomData&&chatroomData.hasCharacter?(charType=chatroomData.character,void s()):(a.attr("class","bg-gray-50 dark:bg-gray-700 rounded-lg p-3 mb-4 text-sm"),a.html(`\n        <div class="flex items-center space-x-3">\n          <img src="${userProfile.avatarUrl}" alt="Avatar" class="w-10 h-10 rounded-full">\n          <div>\n            <div class="font-semibold text-gray-900 dark:text-white">${userProfile.username}</div>\n            <div class="text-gray-600 dark:text-gray-300">${userProfile.rankTitle}</div>\n            <div class="text-xs text-gray-500 dark:text-gray-400">${userProfile.expPoints} EXP</div>\n          </div>\n        </div>\n        <div class="mt-2 bg-gray-200 dark:bg-gray-600 rounded-full h-2">\n          <div class="bg-blue-600 dark:bg-blue-500 h-2 rounded-full" style="width: ${userProfile.expProgress.percentage}%"></div>\n        </div>\n        <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">\n          ${userProfile.expProgress.current}/${userProfile.expProgress.required} EXP to next rank\n        </div>\n      `),n.text(__("chatroom.select_character_title")),r.text(__("chatroom.choose_character")),i.text(__("chatroom.save_character")),e.removeClass("hidden"),t.on("submit",async t=>{if(t.preventDefault(),charType=o.val(),userProfile){await saveCharacterSelection(charType)}e.addClass("hidden"),s()}),void o.focus())):($("#playerSetupModal").addClass("hidden"),void $("#loginRequiredModal").removeClass("hidden"))))}function toggleControls(){const e=document.getElementById("controlsContent"),t=document.getElementById("controlsToggle");"none"===e.style.display?(e.style.display="block",t.style.transform="rotate(0deg)"):(e.style.display="none",t.style.transform="rotate(-90deg)")}!async function(){updateLoadingProgress(5,__("chatroom.loading.starting_world")),setTimeout(()=>updateLoadingProgress(15,__("chatroom.loading.loading_characters")),100),await setupPlayerForm(),updateLoadingProgress(35,__("chatroom.loading.setting_up_profile")),types.includes(charType)||(charType=types[0]),updateLoadingProgress(45,__("chatroom.loading.preparing_3d"));const e=new THREE.Scene,t=new THREE.PerspectiveCamera(75,window.innerWidth/window.innerHeight,.1,1e3),o=new THREE.WebGLRenderer({antialias:!0});o.setSize(window.innerWidth,window.innerHeight),o.domElement.style.position="fixed",o.domElement.style.top="0",o.domElement.style.left="0",o.domElement.style.zIndex="0",document.body.appendChild(o.domElement),updateLoadingProgress(55,__("chatroom.loading.setting_up_camera")),window.addEventListener("resize",()=>{t.aspect=window.innerWidth/window.innerHeight,t.updateProjectionMatrix(),o.setSize(window.innerWidth,window.innerHeight)});const a=$("#overlay")[0],n=$("#chatInput")[0],r={},i={};window.players=r,window.getRankColor=getRankColor;const s={x:0,z:0};let l=performance.now(),c=1,d=1,p=!1,m=0,u=null,h=!1;function f(){if(socket&&socket.connected){const e=p?"Run":"Walk";socket.emit("animationStateChanged",{animState:e,direction:c,isMoving:0!==s.x||0!==s.z})}}updateLoadingProgress(65,__("chatroom.loading.creating_3d")),createMedievalJapaneseEnvironment(e),updateLoadingProgress(75,__("chatroom.loading.setting_up_lighting"));const y=new THREE.DirectionalLight(16775388,.8);y.position.set(25,50,25),y.castShadow=!0,e.add(y),e.add(new THREE.AmbientLight(6316128,.6));const g=new THREE.PointLight(15135743,.4,30);g.position.set(0,8,0),e.add(g);function x({id:t,x:o,z:n,charType:s,direction:l,name:c,level:d,rankTitle:p,avatarUrl:m,expPoints:u}){if(r[t])return;const h=new THREE.TextureLoader,f={sprite:null,animTextures:{},animState:"Idle",animFrame:0,lastAnimTime:performance.now(),direction:l||1,x:o,z:n,name:c||__("chatroom.default_player_name"),level:d||1,rankTitle:p||__("chatroom.default_rank_title"),avatarUrl:m||"",expPoints:u||0,animLockState:null,animLockUntil:0,_lastPos:{x:o,z:n},_lastMovementTime:0,_movementVelocity:{x:0,z:0},_animationStateTime:0,_isMoving:!1};r[t]=f;const y=document.createElement("div");y.className="chatBubble absolute left-1/2 -translate-x-1/2 px-3 py-2 rounded-lg shadow-lg bg-black/60 dark:bg-gray-800/70 text-white text-sm font-medium max-w-[160px] min-w-[50px] text-center pointer-events-none z-30",y.style.display="none";const g=document.createElement("div");let x="playerName absolute left-1/2 -translate-x-1/2 bottom-full mb-8 px-2 py-1 rounded text-white text-sm font-semibold pointer-events-auto z-40 cursor-pointer hover:bg-white/20 transition-colors duration-200";f.level>=15&&(x+=" animate-pulse"),g.className=x;let w=`<span class="inline-block px-1.5 py-0.5 rounded text-xs font-bold mr-1" style="background-color: ${getRankColor(f.level)}; color: white;">${f.rankTitle}</span>`;function _(){if(f.sprite)return;const t=f.animTextures.Idle;if(t&&t.length>0){const a=new THREE.Sprite(new THREE.SpriteMaterial({map:t[0],transparent:!0,alphaTest:f.alphaTest||.1})),r=f.spriteScale||{x:2,y:2,z:1};a.scale.set(r.x,r.y,r.z),a.position.set(o,f.spriteHeight||2,n),e.add(a),f.sprite=a}else for(const[t,a]of Object.entries(f.animTextures))if(a&&a.length>0){const t=new THREE.Sprite(new THREE.SpriteMaterial({map:a[0],transparent:!0,alphaTest:f.alphaTest||.1})),r=f.spriteScale||{x:2,y:2,z:1};t.scale.set(r.x,r.y,r.z),t.position.set(o,f.spriteHeight||2,n),e.add(t),f.sprite=t;break}}function E(e,t){h.load(`/chatroom/assets/characters/${s}/${t.file}`,o=>{o.wrapS=o.wrapT=THREE.ClampToEdgeWrapping,o.magFilter=THREE.NearestFilter,o.minFilter=THREE.NearestFilter,o.format=THREE.RGBAFormat;const a=[],n=1/t.frames,r=.001;for(let e=0;e<t.frames;e++){const t=o.clone();t.wrapS=THREE.ClampToEdgeWrapping,t.wrapT=THREE.ClampToEdgeWrapping;const i=e*n+r,s=n-.002;t.offset.set(i,r),t.repeat.set(s,.998),t.magFilter=THREE.NearestFilter,t.minFilter=THREE.NearestFilter,t.format=THREE.RGBAFormat,t.needsUpdate=!0,a.push(t)}f.animTextures[e]=a,_()},void 0,e=>{e.target&&e.target.src&&fetch(e.target.src).then(e=>{400===e.status&&P(__("errors.system_error")||"System Error",__("api.chatroom.character_update_failed")||"Unable to load character sprites. Please contact support if this continues.")}).catch(()=>{})})}f.level>=20?w=`👑 ${w}`:f.level>=15&&(w=`⭐ ${w}`),g.innerHTML=`${w}${f.name}`,f.level>=10&&(g.style.textShadow="0 0 10px rgba(255, 255, 255, 0.5)"),f.rankTitle&&(g.title=`Click to view profile - ${f.rankTitle} (${f.expPoints} EXP)`),g.addEventListener("click",()=>{window.showUserProfile&&window.showUserProfile(t)}),t!==socket.id&&a.appendChild(g),a.appendChild(y),i[t]={bubble:y,nameLabel:g},loadCharacterConfig(s).then(e=>{const t=e.animations.states;f.characterConfig=e,e.display&&(f.spriteScale=e.display.scale||{x:2,y:2,z:1},f.spriteHeight=e.display.spriteHeight||2,f.alphaTest=e.display.alphaTest||.1);for(const[e,o]of Object.entries(t))"sheet"===o.type?E(e,o):"single"===o.type&&h.load(`/chatroom/assets/characters/${s}/${o.file}`,t=>{t.magFilter=THREE.NearestFilter,t.minFilter=THREE.NearestFilter,t.format=THREE.RGBAFormat,t.needsUpdate=!0,f.animTextures[e]=[t],_()},void 0,e=>{e.target&&e.target.src&&fetch(e.target.src).then(e=>{400===e.status&&P(__("errors.system_error")||"System Error",__("api.chatroom.character_update_failed")||"Unable to load character sprites. Please contact support if this continues.")}).catch(()=>{})})}).catch(e=>{const t=getFallbackCharacterConfig(s);f.characterConfig=t;for(const[e,o]of Object.entries(t.animations.states))"sheet"===o.type&&E(e,o)})}function w(t){const o=r[t];o&&o.sprite&&e.remove(o.sprite),delete r[t];const n=i[t];n&&(n.bubble&&a.removeChild(n.bubble),n.nameLabel&&a.removeChild(n.nameLabel),delete i[t])}if([{x:-25,z:-25},{x:25,z:-25},{x:-25,z:25},{x:25,z:25}].forEach(t=>{const o=new THREE.PointLight(16770229,.4,20);o.position.set(t.x,9,t.z),e.add(o)}),t.position.set(0,10,10),t.lookAt(0,0,0),updateLoadingProgress(85,__("chatroom.loading.connecting_to_server")),!window.user||!window.user.id||"undefined"==typeof io)return void P(__("chatroom.authentication_required"),__("chatroom.please_login_chatroom"));let _=sessionStorage.getItem("socket_token");function E(e,t,o=c){if(!e||!e.sprite)return;let a=t;if(-1===o&&e.animTextures[t+"_Left"]?a=t+"_Left":1===o&&e.animTextures[t]||e.animTextures[t]?a=t:e.animTextures[t+"_Left"]&&(a=t+"_Left"),e.animState!==a&&e.animTextures[a]){Math.random(),e.animState=a,e.animFrame=0;let t=0;a.endsWith("_Left")&&(t=e.animTextures[a].length-1),e.animTextures[a][t]&&(e.sprite.material.map=e.animTextures[a][t],e.sprite.material.needsUpdate=!0),e.lastAnimTime=performance.now(),e.sprite.scale.x=2,e.sprite.scale.y=2,e.sprite.scale.z=1,e.direction=o,e===r[socket?.id]&&(d=o)}}function v(e){}function k(e){const t=document.getElementById("onlineCount");t&&(t.textContent=e),T()}function T(){const e=document.getElementById("playersList");if(!e)return;const t=Object.entries(r).sort(([,e],[,t])=>t.level-e.level);e.innerHTML=t.map(([e,t])=>{const o=getRankColor(t.level);let a="";return t.level>=20?a="👑":t.level>=15?a="⭐":t.level>=10&&(a="💎"),`\n        <div class="flex items-center justify-between py-1 px-2 rounded hover:bg-white/10 cursor-pointer" onclick="showUserProfile('${e}')">\n          <div class="flex items-center space-x-1">\n            ${a?`<span>${a}</span>`:""}\n            <span class="font-medium">${z(t.name)}</span>\n          </div>\n          <span class="px-1 py-0.5 rounded text-xs font-bold" style="background-color: ${o}; color: white;">\n            ${t.level}\n          </span>\n        </div>\n      `}).join("")}function b(e,t,o=null){const a=document.getElementById("chatHistory"),n=document.getElementById("chatContainer");if(!a)return;n&&"none"===n.style.display&&(n.style.display="block");let i="",s="font-medium text-white",l="text-white/80 flex-1";if(o&&r[o]){const e=r[o],t=getRankColor(e.level);let a=`R${e.level}`;e.level>=20?a=`👑 ${a}`:e.level>=15&&(a=`⭐ ${a}`),i=`<span class="inline-block px-1 py-0.5 rounded text-xs font-bold mr-1" style="background-color: ${t}; color: white;">${a}</span>`,e.level>=20?(s="font-bold text-yellow-300 drop-shadow-lg",l="text-yellow-100 flex-1 font-medium"):e.level>=15?(s="font-bold text-purple-300",l="text-purple-100 flex-1"):e.level>=10?(s="font-semibold text-blue-300",l="text-blue-100 flex-1"):e.level>=5&&(s="font-medium text-green-300")}const c=document.createElement("div");c.className="text-sm",c.innerHTML=`\n      <div class="flex items-start space-x-2">\n        <span class="${s}">${i}${z(e)}:</span>\n        <span class="${l}">${z(t)}</span>\n      </div>\n    `,a.appendChild(c);const d=a.children;d.length>15&&d[0].remove(),a.scrollTop=a.scrollHeight}function z(e){const t=document.createElement("div");return t.textContent=e,t.innerHTML}async function M(e,t=null){if(window.user&&window.user.id)try{const o=await $.post("/chatroom/award-exp",{action:e,interaction:t});200===o.status&&o.data.expGained>0&&(function(e){const t=document.createElement("div");t.className="fixed top-20 right-4 bg-green-500 dark:bg-green-600 text-white px-4 py-2 rounded-lg shadow-lg z-50 transform translate-x-full transition-transform duration-300",t.innerHTML=`\n      <div class="flex items-center space-x-2">\n        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">\n          <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>\n        </svg>\n        <span>+${e.expGained} EXP</span>\n      </div>\n    `,document.body.appendChild(t),setTimeout(()=>{t.classList.remove("translate-x-full")},100),setTimeout(()=>{t.classList.add("translate-x-full"),setTimeout(()=>{document.body.removeChild(t)},300)},3e3)}(o.data),userProfile&&(userProfile.expPoints=o.data.totalExp,userProfile.level=o.data.newLevel,o.data.leveledUp&&function(e){const t=document.createElement("div");t.className="fixed top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-gradient-to-r from-yellow-400 to-orange-500 dark:from-yellow-500 dark:to-orange-600 text-white px-8 py-6 rounded-xl shadow-2xl z-50 opacity-0 scale-75 transition-all duration-500",t.innerHTML=`\n      <div class="text-center">\n        <div class="text-3xl font-bold mb-2">🎉 RANK UP! 🎉</div>\n        <div class="text-xl font-semibold">Rank ${e.newLevel}</div>\n        <div class="text-sm opacity-90">+${e.expGained} EXP gained</div>\n      </div>\n    `,document.body.appendChild(t),setTimeout(()=>{t.classList.remove("opacity-0","scale-75"),t.classList.add("opacity-100","scale-100")},100),setTimeout(()=>{t.classList.add("opacity-0","scale-75"),setTimeout(()=>{document.body.removeChild(t)},500)},4e3)}(o.data)))}catch(e){}}_||(_="session_"+Date.now()+"_"+Math.random().toString(36).substr(2,9),sessionStorage.setItem("socket_token",_)),socket=io({auth:{userId:window.user.id,token:_},transports:["websocket","polling"],timeout:5e3}),socket.on("connect",()=>{updateLoadingProgress(95,__("chatroom.loading.finalizing_setup"));const e=chatroomData?.lastX||0,t=chatroomData?.lastZ||0,o={name:name,charType:charType,level:userProfile?.level||1,rankTitle:userProfile?.rankTitle||__("chatroom.default_rank_title"),avatarUrl:userProfile?.avatarUrl||"",expPoints:userProfile?.expPoints||0,x:e,z:t};socket.emit("newUser",o),v(!0),$.ajax({url:"/chatroom/history",method:"GET",dataType:"json"}).done(function(e){if(200===e.status&&e.data.messages){const t=document.getElementById("chatHistory");t&&(t.innerHTML=""),e.data.messages.forEach(e=>{let t=null;Object.entries(r).forEach(([o,a])=>{a.name===e.name&&(t=o)}),b(e.name,e.message,t)})}}).fail(function(e,t,o){}),setTimeout(()=>{updateLoadingProgress(100,__("chatroom.loading.welcome_to_world")),setTimeout(()=>{hideLoadingScreen()},500)},300)}),socket.on("connect_error",e=>{P(__("chatroom.connection_error"),__("chatroom.failed_connect_chatroom")+": "+e.message),v(!1)}),socket.on("disconnect",e=>{v(!1);P(__("chatroom.connection_lost"),__("chatroom.lost_connection_server")+": "+e)}),socket.on("chatroom_kicked",e=>{h=!0,socket&&(socket.removeAllListeners(),socket.disconnect(!0),socket=null),v(!1);const t=document.createElement("div");t.className="fixed inset-0 z-50 flex items-center justify-center";const o=__("chatroom.multiple_connections_detected"),a=__("chatroom.multiple_connections_message"),n=__("chatroom.what_you_can_do"),r=__("chatroom.use_other_chatroom_tab"),i=__("chatroom.close_this_continue_other"),s=__("chatroom.close_other_refresh_this"),l=__("chatroom.close_this_tab"),c=__("chatroom.refresh_reconnect");t.innerHTML=`\n      <div class="bg-black/70 backdrop-blur-md absolute inset-0"></div>\n      <div class="relative bg-white dark:bg-gray-800 rounded-2xl shadow-2xl max-w-md w-full mx-4 p-6">\n        <div class="text-center mb-6">\n          <div class="w-16 h-16 bg-orange-100 dark:bg-orange-900/30 rounded-full flex items-center justify-center mx-auto mb-4">\n            <svg class="w-8 h-8 text-orange-600 dark:text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">\n                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126zM12 15.75h.007v.008H12v-.008z"/>\n            </svg>\n          </div>\n          <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">${o}</h3>\n          <p class="text-gray-600 dark:text-gray-300">${a}</p>\n        </div>\n        \n        <div class="bg-blue-50 dark:bg-blue-900/30 rounded-lg p-4 mb-6">\n          <div class="flex items-start space-x-3">\n            <svg class="w-5 h-5 text-blue-600 dark:text-blue-400 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">\n                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>\n            </svg>\n            <div class="text-sm text-blue-800 dark:text-blue-200">\n              <p class="font-medium mb-1">${n}</p>\n              <ul class="list-disc list-inside space-y-1">\n                <li>${r}</li>\n                <li>${i}</li>\n                <li>${s}</li>\n              </ul>\n            </div>\n          </div>\n        </div>\n        \n        <div class="flex space-x-3">\n          <button onclick="window.close()" class="flex-1 bg-gray-600 dark:bg-gray-500 text-white py-3 px-4 rounded-lg font-medium hover:bg-gray-700 dark:hover:bg-gray-600 transition">\n            ${l}\n          </button>\n          <button onclick="window.location.reload()" class="flex-1 bg-purple-600 dark:bg-purple-500 text-white py-3 px-4 rounded-lg font-medium hover:bg-purple-700 dark:hover:bg-purple-600 transition">\n            ${c}\n          </button>\n        </div>\n      </div>\n    `,document.body.style.overflow="hidden",document.body.appendChild(t),t.addEventListener("click",e=>{e.stopPropagation(),e.preventDefault()}),document.addEventListener("keydown",e=>{e.preventDefault(),e.stopPropagation()},!0)}),socket.on("currentPlayers",e=>{Object.values(e).forEach(x),k(Object.keys(e).length),T()}),socket.on("newPlayer",e=>{x(e),k(Object.keys(r).length+1),T()}),socket.on("playerMoved",({id:e,x:t,z:o,direction:a,animState:n})=>{const i=r[e];if(i){const e=performance.now(),r=e-(i._lastMovementTime||e);r>0&&(i._movementVelocity.x=(t-i.x)/r*1e3,i._movementVelocity.z=(o-i.z)/r*1e3),i.x=t,i.z=o,i._lastMovementTime=e,void 0!==a&&(i.direction=a),n&&(i._receivedAnimState=n),i.sprite&&i.sprite.position.set(t,2,o),i._isMoving=!0}}),socket.on("playerCharacterChanged",e=>{const{id:t,charType:o,x:a,z:n,name:r,level:i,rankTitle:s,avatarUrl:l,expPoints:c,direction:d}=e;w(t),x({id:t,x:a,z:n,charType:o,direction:d,name:r,level:i,rankTitle:s,avatarUrl:l,expPoints:c}),t===socket.id&&(o=e.charType),T()}),socket.on("playerDisconnected",e=>{w(e),k(Object.keys(r).length),T()}),socket.on("chatMessage",({id:e,name:t,message:o})=>{const a=i[e];if(a){const{bubble:e}=a;e.textContent=o,e.style.display="block",e.classList.add("chat-bubble"),setTimeout(()=>{e.style.display="none",e.classList.remove("chat-bubble")},8e3)}b(e===socket.id?__("chatroom.you"):t||__("chatroom.unknown_player"),o,e===socket.id?null:e)}),socket.on("playAnim",({id:e,animation:t,duration:o,direction:a})=>{const n=r[e];n&&(E(n,t,a||n.direction||1),n.animLockUntil=performance.now()+(o||600),n.animLockState=t)}),socket.on("animationStateChanged",({id:e,animState:t,direction:o,isMoving:a})=>{const n=r[e];n&&(n._receivedAnimState=t,n.direction=o,n._lastMovementTime=performance.now(),n._isMoving=a,(!n.animLockState||performance.now()>=n.animLockUntil)&&E(n,a?t:"Idle",o))}),window.addEventListener("keydown",e=>{if(document.activeElement===n)return;if(!socket||!socket.connected)return;performance.now();function t(e,t){const o=r[socket.id];o&&(E(o,e,c),m=performance.now()+t,u=e,socket.emit("playAnim",{animation:e,duration:t,direction:c}))}switch(e.key.toLowerCase()){case"shift":p=!0,f();break;case"arrowup":case"w":s.z=-1;break;case"arrowdown":case"s":s.z=1;break;case"arrowleft":case"a":s.x=-1,c=-1,f();break;case"arrowright":case"d":s.x=1,c=1,f();break;case"g":t("Attack_1",600);const o=Date.now();o-H>R&&(M("social_interaction","attack_1"),H=o);break;case"h":t("Attack_2",700);const a=Date.now();a-H>R&&(M("social_interaction","attack_2"),H=a);break;case"j":t("Attack_3",600);const n=Date.now();n-H>R&&(M("social_interaction","attack_3"),H=n);break;case"k":t("Shield",500);const r=Date.now();r-H>R&&(M("social_interaction","shield"),H=r);break;case" ":e.preventDefault(),t("Jump",900);const i=Date.now();i-H>R&&(M("social_interaction","jump"),H=i);break;case"t":socket&&socket.connected&&socket.emit("teleportHome")}}),window.addEventListener("keyup",e=>{switch(e.key.toLowerCase()){case"shift":p=!1,f();break;case"arrowup":case"w":case"arrowdown":case"s":s.z=0,f();break;case"arrowleft":case"a":case"arrowright":case"d":s.x=0,f()}}),n.addEventListener("keydown",e=>{if("Enter"===e.key&&n.value.trim()&&socket&&socket.connected){const e=n.value.trim();if("/home"===e||"/teleport"===e||"/stuck"===e)return socket.emit("teleportHome"),void(n.value="");socket.emit("chatMessage",e),n.value="";const t=Date.now();t-L>C&&(M("message"),L=t)}});let L=0;const C=3e4;let H=0;const R=1e4;function P(e,t){document.querySelectorAll("[data-error-modal]:not(#errorModalTemplate)").forEach(e=>e.remove());const o=document.getElementById("errorModalTemplate");if(!o)return;const a=o.cloneNode(!0);a.id="errorModal",a.classList.remove("hidden"),a.querySelector("#errorModalTitle").textContent=e,a.querySelector("#errorModalMessage").textContent=t,a.querySelector("#errorModalHomeBtn").onclick=()=>{a.remove(),document.body.style.overflow="",window.location.href="/"},a.querySelector("#errorModalRetryBtn").onclick=()=>{window.location.reload()},document.body.style.overflow="hidden",document.body.appendChild(a),a.addEventListener("click",e=>{e.stopPropagation(),e.preventDefault()})}window.addEventListener("beforeunload",()=>{const e=r[socket?.id];e&&socket&&socket.connected&&saveCoordinates(e.x,e.z)}),function a(){if(h)return;requestAnimationFrame(a);const n=performance.now(),d=(n-l)/1e3;l=n;const f=r[socket.id];if(f&&f.sprite){const e=f.sprite;if(n<m&&u)E(f,u,c);else if(u=null,0!==s.x||0!==s.z){const t=p?5:3;let o=e.position.x+s.x*t*d,a=e.position.z+s.z*t*d;if(checkCollision(o,a)){let n=!checkCollision(e.position.x+s.x*t*d,e.position.z),r=!checkCollision(e.position.x,e.position.z+s.z*t*d);if(n){if(o=e.position.x+s.x*t*d,a=e.position.z,e.position.x=o,f.x=o,f.direction=c,socket&&socket.connected){const e=p?"Run":"Walk";socket.emit("move",{x:o,z:a,direction:c,animState:e}),saveCoordinates(o,a)}}else if(r&&(o=e.position.x,a=e.position.z+s.z*t*d,e.position.z=a,f.z=a,f.direction=c,socket&&socket.connected)){const e=p?"Run":"Walk";socket.emit("move",{x:o,z:a,direction:c,animState:e}),saveCoordinates(o,a)}}else if(e.position.x=o,e.position.z=a,f.x=o,f.z=a,f.direction=c,socket&&socket.connected){const e=p?"Run":"Walk";socket.emit("move",{x:o,z:a,direction:c,animState:e}),saveCoordinates(o,a)}u||E(f,p?"Run":"Walk",c)}else u||E(f,"Idle",c);t.position.set(e.position.x,e.position.y+2.5,e.position.z+3),t.lookAt(e.position)}Object.entries(r).forEach(([e,t])=>{if(!t.sprite)return;e!==socket.id&&(t.sprite.position.x=t.x,t.sprite.position.z=t.z,t.sprite.position.y=2,t.animLockState&&n<(t.animLockUntil||0)?E(t,t.animLockState,t.direction):(t.animLockState&&(t.animLockState=null),t._isMoving&&t._receivedAnimState?E(t,t._receivedAnimState,t.direction):t._isMoving||E(t,"Idle",t.direction)));const o=t.animTextures[t.animState]||[],a=t.characterConfig?.animations?.frameRate||80;if(o.length>1&&n-t.lastAnimTime>a){t.animFrame=(t.animFrame+1)%o.length;let e=t.animFrame;t.animState&&t.animState.endsWith("_Left")&&(e=o.length-1-t.animFrame),e>=0&&e<o.length&&o[e]&&(t.sprite.material.map=o[e],t.sprite.material.needsUpdate=!0),t.lastAnimTime=n}}),o.render(e,t),Math.random(),Object.keys(r).forEach(e=>{const o=r[e],a=i[e];if(o&&o.sprite&&a){const{bubble:n,nameLabel:r}=a,i=o.sprite.position.clone();i.y+=1.2,i.project(t);const s=(.5*i.x+.5)*window.innerWidth,l=(.5*-i.y+.5)*window.innerHeight;i.z<1&&i.x>=-1&&i.x<=1&&i.y>=-1&&i.y<=1?(e!==socket.id?(r.style.left=s+"px",r.style.top=l+"px",r.style.transform="translate(-50%, -100%)",r.style.display="block"):r.style.display="none","block"===n.style.display&&(n.style.left=s+"px",n.style.top=l-8+"px",n.style.transform="translate(-50%, -100%)")):(r.style.display="none","block"===n.style.display&&(n.style.display="none"))}})}()}(),document.addEventListener("DOMContentLoaded",function(){(async()=>{const e=document.getElementById("charType");e&&(0===types.length&&await loadAvailableCharacterTypes(),types.length>0?(e.innerHTML="",types.forEach(t=>{const o=document.createElement("option");o.value=t,o.textContent=t,e.appendChild(o)}),e.value=charType||types[0]):(e.innerHTML='<option value="Fighter">Fighter</option>',e.value="Fighter"))})()});