import express from 'express';
import multer from 'multer';
import * as controller from '../controllers/plugin.js';

const router = express.Router();
const upload = multer();

// Main plugin route - handles /plugin?name=plugin-name&action=action
router.get('/', controller.pluginHandler);
router.post('/', upload.any(), controller.pluginHandler);

// Plugin assets - /plugin/assets?name=plugin-name
router.get('/assets/*', controller.pluginAssets);

export default router;